﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace DocumentProcessing
{
    // Listing 5-13. Dodanie szybkiego testu weryfikacyjnego do procesu przetwarzania dokumentów
    class DocumentProcessor
    {
        class ActionCheckPair
        {
            public Action<Document> Action { get; set; }
            public Check QuickCheck { get; set; }
        }

        private readonly List<ActionCheckPair> processes = new List<ActionCheckPair>();


        public void AddProcess(Action<Document> action)
        {
            AddProcess(action, null);
        }

        public void AddProcess(Action<Document> action, Check quickCheck)
        {
            processes.Add(
            new ActionCheckPair { Action = action, QuickCheck = quickCheck });
        }

        public void Process(Document doc)
        {
            // Najpierw wykonujemy szybką weryfikację.
            foreach (ActionCheckPair process in processes)
            {
                if (process.QuickCheck != null && !process.QuickCheck(doc))
                {
                    Console.WriteLine("Przetwarzanie nie zakończy się pomyślnie.");
                    return;
                }
            }

            // Teraz wykonujemy akcję.
            foreach (ActionCheckPair process in processes)
            {
                process.Action(doc);
            }
        }
    }
}